/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameInfo;
import cds.aladin.Glu;
import cds.aladin.MetaDataTree;
import cds.aladin.MyInputStream;
import cds.aladin.MyListener;
import cds.aladin.PlanImage;
import cds.aladin.Server;
import cds.aladin.TreeView;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public final class ServerAladin
extends Server
implements Runnable,
MyListener {
    Thread thread;
    JCheckBox byTree;
    ButtonGroup format;
    JRadioButton jpgCb;
    JRadioButton fitsCb;
    JLabel step1;
    JLabel step2;
    String STEP1;
    String STEP2;
    String BYTREE;
    String DEFFMT;
    String SERVERR;
    String GLUDEFQUAL = "DefQual";
    String GLUIMAGE = "Image";
    String GLUQUALIFIER = "Aladin.qualifierServer";
    static String[] ACOLOR = new String[]{"J", "F", "E", "EJ", "V", "O", "R", "I", "S", "SR", "ER", "U", "B", "N"};
    static String[] COLOR = new String[]{"Blue", "Red", "Red", "Equ. blue", "Visible", "Blue", "Red", "InfraRed", "Short red", "Short red", "Equ. red", "UV", "Blue", "Red/IR"};
    static String lastQual = "";
    static boolean flagContWhichQual = false;
    private String _target;
    private String _criteria;
    private String _label;
    private String _origin;
    private String _serverTaskId;
    private boolean flagIDHASIAcall = false;
    private boolean flagCreatPlane = false;
    private boolean launchLock = false;
    private boolean olistView = true;
    static String otarget = null;
    boolean flagClear = true;

    private String getTagGlu(String tag) {
        return tag;
    }

    protected ServerAladin(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.type = 1;
        this.aladinLogo = "AladinLogo.gif";
        this.gluTag = "Aladin";
        this.DISCOVERY = true;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 2;
        JPanel tp = new JPanel();
        tp.setBackground(Aladin.BLUE);
        Dimension d = this.makeTitle(tp, this.title);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        this.step1 = new JLabel(this.STEP1);
        this.step1.setForeground(Color.blue);
        this.step1.setBounds(80, y += d.height + 10, 400, 19);
        y += 20;
        this.add(this.step1);
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 16);
        tPanel.setBounds(0, y, XWIDTH, h);
        y += h;
        this.add(tPanel);
        this.modeCoo = 5;
        this.modeRad = 0;
        if (this.radius != null) {
            this.radius.setText("0 arcmin");
        }
        this.step2 = new JLabel(this.STEP2);
        this.step2.setBounds(15, y, 310, 19);
        this.add(this.step2);
        this.byTree = new JCheckBox(this.BYTREE, false);
        this.byTree.setActionCommand(this.BYTREE);
        this.byTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerAladin.this.changeViewMode();
            }
        });
        int wpos = 150;
        int xpos = XWIDTH - 10 - wpos;
        this.byTree.setBounds(xpos, y + 2, wpos, 18);
        y += 22;
        this.byTree.setBackground(Aladin.BLUE);
        this.add(this.byTree);
        this.tree = new MetaDataTree(aladin, null);
        this.tree.setAllowSortByFields(false);
        this.tree.setFlat(true);
        this.tree.setSortable(true);
        this.tree.setStateChangedListener(this);
        JScrollPane scrollTree = new JScrollPane(this.tree);
        this.tree.setScroll(scrollTree);
        scrollTree.setBackground(this.tree.bkgColor);
        scrollTree.setBounds(10, y, XWIDTH - 20, 217);
        this.add(scrollTree);
        JPanel formatPanel = new JPanel();
        formatPanel.setBackground(Aladin.BLUE);
        formatPanel.setBounds(110, y += 215, XWIDTH, 30);
        y += 35;
        formatPanel.setLayout(new FlowLayout(0));
        formatPanel.setFont(Aladin.PLAIN);
        this.format = new ButtonGroup();
        formatPanel.add(new JLabel(this.DEFFMT));
        this.jpgCb = new JRadioButton("JPEG", true);
        formatPanel.add(this.jpgCb);
        this.jpgCb.setActionCommand("JPEG");
        this.jpgCb.setBackground(Aladin.BLUE);
        this.format.add(this.jpgCb);
        this.fitsCb = new JRadioButton("FITS", false);
        formatPanel.add(this.fitsCb);
        this.fitsCb.setActionCommand("FITS");
        this.fitsCb.setBackground(Aladin.BLUE);
        this.format.add(this.fitsCb);
        this.add(formatPanel);
        this.setStepColor(this.step1, this.step2);
        this.setMaxComp(scrollTree);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("ALADINTITLE");
        this.BYTREE = Aladin.chaine.getString("ALADINBYTREE");
        this.DEFFMT = Aladin.chaine.getString("ALADINDEFFMT");
        this.aladinLabel = Aladin.chaine.getString("ALADINNAME");
        this.description = Aladin.chaine.getString("ALADININFO");
        this.verboseDescr = Aladin.chaine.getString("ALADINDESC");
        this.STEP1 = Aladin.chaine.getString("ALADINSTEP1");
        this.STEP2 = Aladin.chaine.getString("ALADINSTEP2");
        this.SERVERR = Aladin.chaine.getString("ALADINSERVERR");
    }

    @Override
    protected boolean is(String s) {
        return s.equalsIgnoreCase("Aladin");
    }

    protected static String fixChar(String s, int l) {
        char[] a = s.toCharArray();
        char[] b = new char[l];
        for (int i = 0; i < l; ++i) {
            b[i] = i < a.length ? a[i] : 32;
        }
        return new String(b);
    }

    static String change2FITS(String u) {
        int i = u.indexOf("JPEG");
        if (i < 0) {
            return u;
        }
        return u.substring(0, i) + "FITS" + u.substring(i + 4, u.length());
    }

    static String whichQualifier(String qual) {
        flagContWhichQual = false;
        return ServerAladin.whichQual(qual);
    }

    static String whichQual(String qual) {
        boolean ts = flagContWhichQual && qual.equals(lastQual);
        flagContWhichQual = true;
        StringBuffer res = new StringBuffer();
        StringTokenizer st = new StringTokenizer(qual);
        if (st.countTokens() < 3) {
            return qual;
        }
        String s = st.nextToken();
        String c = st.nextToken();
        String o = st.nextToken();
        res.append(ServerAladin.fixChar(ts ? "   \"" : s, 6));
        res.append(ServerAladin.fixChar(ts ? "    \"   \"" : "  " + (o.equals("MAMA") ? "MAMA/CAI" : (o.equalsIgnoreCase("STSCI") ? "DSS1/STScI" : (o.equalsIgnoreCase("DSS2") ? "DSS2/STScI" : (s.equalsIgnoreCase("2MASS") ? "UMass/IRSA" : o)))), 12));
        if (s.equalsIgnoreCase("2MASS") || s.equalsIgnoreCase("EROSI")) {
            res.append(ServerAladin.fixChar("  " + c, 12));
        } else {
            int i;
            for (i = 0; i < ACOLOR.length && !ACOLOR[i].equals(c); ++i) {
            }
            if (i < ACOLOR.length) {
                res.append(ServerAladin.fixChar(ts ? "  \"  \"" : "  " + c + " (" + COLOR[i] + ")", 12));
            } else {
                res.append(ServerAladin.fixChar(ts ? "  \"" : "  " + c, 12));
            }
        }
        lastQual = qual;
        return res.toString();
    }

    private void freeLaunchLock() {
        this.launchLock = false;
    }

    private synchronized boolean getLaunchLock() {
        if (this.launchLock) {
            return false;
        }
        this.launchLock = true;
        return true;
    }

    @Override
    protected synchronized int createPlane(String target, String radius, String criteria, String label, String origin) {
        String format = null;
        String resol = null;
        String qual = null;
        if ((criteria = ServerAladin.specialUnQuoteCriteria(criteria)) != null && !this.isAllSky(criteria)) {
            int pos1 = criteria.indexOf(47);
            int pos2 = criteria.indexOf(47, pos1 + 1);
            if (pos1 > 0 && pos2 > pos1) {
                qual = criteria.replace('/', ' ');
                resol = "FULL";
                format = "JPEG";
                criteria = null;
            }
        }
        if (criteria != null) {
            while (!this.getLaunchLock()) {
                Util.pause(500);
            }
            this._target = target;
            this._criteria = criteria;
            this._origin = origin;
            this._label = label;
            this._serverTaskId = this.aladin.synchroServer.start("ServerAladin.createPlane/" + target);
            this.thread = new Thread((Runnable)this, "AladinCreatePlane");
            this.flagCreatPlane = true;
            this.thread.start();
            return 0;
        }
        return this.creatAladinPlane(target, format, resol, qual, label, origin);
    }

    @Override
    public void run() {
        if (this.flagIDHASIAcall) {
            this.flagIDHASIAcall = false;
            this.submitThread();
        } else if (this.flagCreatPlane) {
            this.flagCreatPlane = false;
            this.creatPlaneThread();
        }
        this.setStepColor(this.step1, this.step2);
    }

    protected boolean isAllSky(String s) {
        return s.equalsIgnoreCase("allsky");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatPlaneThread() {
        block8: {
            String qual = null;
            String resol = null;
            String format = null;
            String target = this._target;
            String criteria = this._criteria;
            String origin = this._origin;
            String label = this._label;
            String serverTaskId = this._serverTaskId;
            try {
                this.freeLaunchLock();
                if (this.isAllSky(criteria)) {
                    this.aladin.calque.newPlan("http://aladin.cds.unistra.fr/java/AllSky.fits", "AllSky", "Aladin image server");
                    break block8;
                }
                try {
                    URL u = this.aladin.glu.getURL(this.getTagGlu(this.GLUDEFQUAL), Glu.quote(target) + " " + Glu.quote(criteria));
                    DataInputStream cat = new DataInputStream(Util.openStream(u));
                    qual = cat.readLine();
                    resol = cat.readLine();
                    format = cat.readLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (qual == null || qual.length() == 0) {
                    Aladin.error(this, Aladin.chaine.getString("NOSUCHIMG") + " [" + criteria + "] [" + target + "]", 1);
                } else {
                    this.creatAladinPlane(target, format, resol, qual, label, origin);
                }
            }
            finally {
                this.aladin.synchroServer.stop(serverTaskId);
            }
        }
    }

    protected int creatAladinPlane(String target, String format, String resol, String qual, String label, String origin) {
        URL u;
        if (format == null) {
            format = "JPEG";
        }
        if (resol == null) {
            resol = "FULL";
        }
        String s = Glu.quote(target) + " " + Glu.quote(format) + " " + Glu.quote(resol);
        if (qual != null && qual.length() > 0) {
            s = s + " " + Glu.quote(qual);
        }
        if ((u = this.aladin.glu.getURL(this.getTagGlu(this.GLUIMAGE), s)) == null) {
            Aladin.error(this, this.WERROR, 1);
            return -1;
        }
        if (!this.verif(1, target, qual, PlanImage.getFmt(format) + "/" + PlanImage.getRes(resol))) {
            return -1;
        }
        label = this.getDefaultLabelIfRequired(label, ServerAladin.getPlanLabel(resol, qual));
        if (origin == null) {
            origin = qual.indexOf("MAMA") >= 0 ? "CAI/Paris - provided by CDS image server" : (qual.indexOf("DSS2") >= 0 ? "STScI -  provided by CDS image server" : (qual.indexOf("2MASS") >= 0 ? "UMass/IRSA - provided by CDS image server" : "STScI - provided by CDS"));
        }
        this.aladin.targetHistory.add(target);
        return this.aladin.calque.newPlanImage(u, 0, label, target, qual, origin, PlanImage.getFmt(format), PlanImage.getRes(resol), null);
    }

    private void submitThread() {
        this.waitCursor();
        URL url = null;
        try {
            String r;
            String objc = null;
            String obj = null;
            try {
                obj = this.getTarget();
                r = this.getRadius(false);
                r = r == null ? "0" : "" + ServerAladin.getRM(r) / 60.0;
                objc = this.sesameIfRequired(obj, ":");
                if (objc == null) {
                    throw new Exception(this.UNKNOWNOBJ + " [" + obj + "]");
                }
            }
            catch (Exception e1) {
                Aladin.error(this, e1.getMessage(), 1);
                this.defaultCursor();
                this.ball.setMode(3);
                return;
            }
            url = this.aladin.glu.getURL(this.getTagGlu(this.GLUQUALIFIER), Glu.quote(TreeView.getDeciCoord(objc)) + Glu.quote(r));
            MyInputStream is = Util.openStream(url);
            if ((is.getType() & 0x200000001800L) == 0L) {
                String err = is.readLine().trim();
                Aladin.error(this, this.SERVERR + "\n\"" + err + "\"");
                this.defaultCursor();
                this.ball.setMode(2);
                return;
            }
            this.updateMetaData(is, this, obj, null);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this, this.SERVERR, 1);
        }
        this.defaultCursor();
        if (this.tree.isEmpty()) {
            this.ball.setMode(3);
        }
    }

    @Override
    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) throws Exception {
        String objc;
        if (radius != "") {
            radius = ServerAladin.getRM(radius) / 60.0 + "";
        }
        if ((objc = this.sesameIfRequired(target, ":")) == null) {
            throw new Exception();
        }
        URL url = this.aladin.glu.getURL("Aladin.qualifierServer", Glu.quote(TreeView.getDeciCoord(objc)) + Glu.quote(radius));
        infoUrl.append(url + "");
        return Util.openStream(url);
    }

    private void changeViewMode() {
        boolean listView;
        boolean bl = listView = !this.byTree.isSelected();
        if (this.olistView != listView) {
            this.tree.setFlat(listView);
            this.olistView = listView;
        }
    }

    protected String getDefaultFormat() {
        return this.format.getSelection().getActionCommand();
    }

    @Override
    public void submit() {
        this.waitCursor();
        String s = this.target.getText().trim();
        if (s != null && this.isAllSky(s)) {
            while (!this.getLaunchLock()) {
                Util.pause(500);
            }
            this._criteria = s;
            this.creatPlaneThread();
            return;
        }
        String obj = this.getTarget();
        if (obj == null) {
            this.defaultCursor();
            return;
        }
        this.memoTarget(obj);
        if (this.tree != null && !this.tree.isEmpty()) {
            if (this.tree.nbSelected() > 0) {
                if (!this.tooManyChecked()) {
                    String format = this.getDefaultFormat();
                    this.tree.loadSelected(format);
                    this.tree.resetCb();
                }
            } else {
                FrameInfo fi = this.aladin.getFrameInfo();
                if (fi.isVisible()) {
                    fi.load();
                } else {
                    Aladin.error(this, this.WNEEDCHECK);
                }
            }
            this.defaultCursor();
            return;
        }
        FrameInfo fi = this.aladin.getFrameInfo();
        if (fi.isVisible()) {
            fi.hide();
        }
        this.thread = new Thread((Runnable)this, "AladinServerMetaData");
        this.flagIDHASIAcall = true;
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    protected static String getPlanLabel(String resol, String qual) {
        return ServerAladin.getPlanLabel(PlanImage.getRes(resol), qual);
    }

    protected static String getPlanLabel(int resol, String qual) {
        StringBuffer s = new StringBuffer();
        String[] f = new String[3];
        StringTokenizer st = new StringTokenizer(qual);
        for (int i = 0; i < 3; ++i) {
            f[i] = st.nextToken();
        }
        if (f[0].indexOf("2MASS") >= 0) {
            f[2] = f[0];
            f[0] = null;
        }
        if (resol == 3) {
            s.append("Pl-");
        } else if (resol == 2) {
            s.append("Lw-");
        }
        if (f[2].equals("STScI") || f[2].equals("STSCI")) {
            s.append("DSS1.");
        } else if (!f[2].startsWith("___")) {
            s.append(f[2] + ".");
        }
        s.append(f[1]);
        if (f[0] != null) {
            s.append("." + f[0]);
        }
        return s.toString();
    }

    protected void memoTarget(String s) {
        otarget = s;
    }

    @Override
    protected void setTarget(String s) {
        if (this.flagClear && otarget != null && !otarget.equals(s)) {
            this.clear();
        }
        this.flagClear = true;
        super.setTarget(s);
    }

    protected static String blankToUnderline(String s) {
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != ' ') continue;
            a[i] = 95;
        }
        return new String(a);
    }

    @Override
    protected void reset() {
        this.tree.resetCb();
        this.flagClear = false;
        super.reset();
        this.setStepColor(this.step1, this.step2);
    }

    @Override
    protected void clear() {
        this.tree.clear();
        super.clear();
        if (this.radius != null) {
            this.radius.setText("0 arcmin");
        }
        this.setStepColor(this.step1, this.step2);
    }

    @Override
    public void fireStateChange(String state) {
        if (state.equals("Flat view")) {
            this.byTree.setSelected(false);
            this.changeViewMode();
        } else if (state.equals("Hierarchical view")) {
            this.byTree.setSelected(true);
            this.changeViewMode();
        }
    }

    @Override
    public void fireStateChange(int i) {
    }
}

